import { StyleSheet } from "react-native";
import dpr from "../../../../../../Utilities/CustomStyleAttribute/dpr";

export const groupProductStyle = StyleSheet.create({
    groupTitle: {
        color: "#898989",
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(14),
        lineHeight: dpr(16),
        marginBottom: dpr(15),
        marginTop: dpr(20),
    },
    groupCont: {
        padding: dpr(14),
        paddingBottom: 0,
        backgroundColor: "#F3F3F3",
        borderRadius: 6,
        maxHeight: dpr(300) + dpr(30),
    },
    individualCont: {
        flexDirection: "row",
        alignItems: "center",
        justifyContent: "space-between",
        marginBottom: dpr(14),
    },
    image: {
        height: dpr(80),
        width: dpr(70),
        backgroundColor: "#FFFFFF",
        borderWidth: 1,
        borderColor: "#DFDFDF",
        borderRadius: 4,
        marginRight: dpr(10),
    },
    name: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(16),
        lineHeight: dpr(17),
        color: "#2C2C2C",
        width: dpr("wf") - dpr(180) - dpr(70),
        textAlign: 'left'
    },
    price: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(16),
        lineHeight: dpr(17),
        color: "#FF6C2E",
        marginVertical: 2,
        width: dpr("wf") - dpr(180) - dpr(70),
        textAlign: 'left'
    },
    stock: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(12),
        lineHeight: dpr(14),
        color: "#898989",
    },
    quantityCont: {
        flexDirection: "row",
        alignItems: "center",
        marginLeft: dpr(11),
        backgroundColor: "#FFFFFF",
        borderWidth: 1,
        borderColor: "#DFDFDF",
        height: dpr(35),
        borderRadius: 4,
        width: dpr(90),
    },
    qtyBtn: {
        height: "100%",
        flexDirection: "row",
        alignItems: "center",
        justifyContent: "flex-end",
        width: dpr(22.5),
    },
    plusBtn: {
        justifyContent: "flex-start",
    },
    quantity: {
        paddingHorizontal: dpr(14),
        color: "#2C2C2C",
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(12),
        width: dpr(45),
        textAlign: "center",
        textAlignVertical: "center",
    },
    optionCont: {
        backgroundColor: "#FCCA19",
        justifyContent: "center",
    },
    option: {
        paddingHorizontal: dpr(7),
        color: "#2C2C2C",
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(12),
    },
});
